<?php 
class MaintRecordController extends AppController { 
	var $name = 'MaintRecord'; 
	var $uses = 'TblMaintenanceRecord'; 
	var $components = array('Security');
	var $helpers = array('Html', 'Form', 'Paginator', 'Js'); 

	function index() { 
		if (isset($_SESSION['TblMaintenanceRecord']['foundset'])) {
		  $this->redirect(array('action'=>'querylist'));
        }
		$this->layout = "index";
		$this->TblMaintenanceRecord->recursive = -1; 
		$this->set('tbl_maintenance_records', $this->paginate()); 
		$page['current_model'] = 'TblMaintenanceRecord';
		$page['current_controller'] = 'maint_record';
		$this->set('page', $page);
	} 

	function view($id = null) { 
		if (!$id || $id == 0) {
			// if invalid id (0) or missing id, use current_record as id
			if (!isset($_SESSION['TblMaintenanceRecord']['current_record']))
				{
				// if invalid id and missing SESSION variable, get first record as current id
				$conditions = array();
				$first_record = $this->TblMaintenanceRecord->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblMaintenanceRecord.id'),'order'=>array('TblMaintenanceRecord.id ASC')));
				$id = $first_record['TblMaintenanceRecord']['id'];
				$_SESSION['TblMaintenanceRecord']['current_record']=$id;
				}	
				else {
				$id = $_SESSION['TblMaintenanceRecord']['current_record'];				
				}	
		}
		$this->layout = "view";
		// put the current record id into session variable
		$_SESSION['TblMaintenanceRecord']['current_record'] = $id;
		// record navigation variables 
		$this->data=$this->TblMaintenanceRecord->read(null, $id); 
		if (isset($_SESSION['TblMaintenanceRecord']['foundset'])) {
			$conditions = array('TblMaintenanceRecord.id'=>$_SESSION['TblMaintenanceRecord']['foundset']);
			$foundset_record_count = $_SESSION['TblMaintenanceRecord']['foundset'];
			// get record position within foundset
			$record_position = '';
			//RecordPositionComment $record_position = array_search($id,$_SESSION['TblMaintenanceRecord']['foundset']) + 1;
		} else {
			// get list of keys for display of record position
			$record_position = '';
			//RecordPositionComment $conditions = array();
			//RecordPositionComment $record_position_query = $this->TblMaintenanceRecord->find('list', array('fields' => 'TblMaintenanceRecord.id'));
			//RecordPositionComment $record_position_list = array_keys($record_position_query); // resolve all keys to numeric array
			//RecordPositionComment $record_position = array_search($id,$record_position_list) + 1;
			$conditions = array();
			$foundset_record_count = $this->TblMaintenanceRecord->find('count');
		}
					if (isset($_SESSION['toolbar_prev']))
					{
					$page['first'] = $this->Session->read('toolbar_first');
					$page['prev'] = $this->Session->read('toolbar_prev');
					$page['next'] = $this->Session->read('toolbar_next');
					$page['total_record_count'] = $this->Session->read('toolbar_total_record_count');
					$page['foundset_record_count'] = $this->Session->read('toolbar_foundset_record_count');
					$page['last'] = $this->Session->read('toolbar_last');
					$page['record_position'] = $this->Session->read('toolbar_record_position');
					$page['current_model'] = 'TblMaintenanceRecord';
					$page['current_controller'] = 'maint_record';
					}
					else 
					{	
		$first_record = $this->TblMaintenanceRecord->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblMaintenanceRecord.id'),'order'=>array('TblMaintenanceRecord.id ASC')));
		$last_record = $this->TblMaintenanceRecord->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblMaintenanceRecord.id'),'order'=>array('TblMaintenanceRecord.id DESC')));
		$neighbors = $this->TblMaintenanceRecord->find('neighbors', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('TblMaintenanceRecord.id'), 'field' => 'id', 'value'=> $id));
		$total_record_count = $this->TblMaintenanceRecord->find('count');
		$page = array();
		$page['first'] = $first_record;
		$page['prev'] = $neighbors['prev'];
		$page['next'] = $neighbors['next'];
		$page['total_record_count'] = $total_record_count;
		$page['foundset_record_count'] = $foundset_record_count;
		$page['last'] = $last_record;
		$page['record_position'] = $record_position;
		$page['current_model'] = 'TblMaintenanceRecord';
		$page['current_controller'] = 'maint_record';
		if (empty($page['prev'])) {
			$page['prev'] = $first_record;
		}
		if (empty($page['next'])) {
			$page['next'] = $last_record;
		}
					}
					if (isset($_SESSION['toolbar_total_record_count'])) 
					{
					$this->Session->delete('toolbar_first');
					$this->Session->delete('toolbar_prev');
					$this->Session->delete('toolbar_next');
					$this->Session->delete('toolbar_total_record_count');
					$this->Session->delete('toolbar_foundset_record_count');
					$this->Session->delete('toolbar_last');
					$this->Session->delete('toolbar_record_position');
					}
		$this->set('page', $page);
		$_SESSION['TblMaintenanceRecordCurrentRecord'] = $this->data; // data for Ext JS grid
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());


	} 

	function query() {
		$this->set('indextypedisplayflag','0');
		// Clear SESSION when performing a new search
		unset($_SESSION['TblMaintenanceRecord']['foundset']);
		if (!empty($this->data)) {
			$conditions = array();
			foreach($this->data['TblMaintenanceRecord'] as $key=>$val) {
				if (!empty($val)) {
					// Exact query
					// $conditions['TblMaintenanceRecord.'.$key] = $val;
					// Fuzzy query
					$conditions['TblMaintenanceRecord.'.$key.' LIKE'] = '%'.$val.'%';
				}
			}
			if (!empty($conditions)) {
				$results = $this->TblMaintenanceRecord->find('all', array(
					'conditions'=>$conditions,
					'order'=>array('TblMaintenanceRecord.id ASC'),
				));
				if (!empty($results)) {
					foreach($results as $result) {
						// Save found record IDs into SESSION
						$_SESSION['TblMaintenanceRecord']['foundset'][] = $result['TblMaintenanceRecord']['id'];
					}
				$this->set('indextypedisplayflag','2');
				} else {
					$this->Session->setFlash('0 Records Found.', 'flash_info'); 
				}
			} else {
				$this->Session->setFlash('Please enter at least one query condition.','flash_info'); 
			}
		} 
		$this->layout = "add";

		$page['current_model'] = 'TblMaintenanceRecord';
		$page['current_controller'] = 'maint_record';
		$this->set('page', $page);
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());
	} 

	function querylist() {
		$page['current_model'] = 'TblMaintenanceRecord';
		$page['current_controller'] = 'maint_record';
		$this->set('page', $page);
		if (isset($_SESSION['TblMaintenanceRecord']['foundset'])) {
			$this->paginate = array(
					'TblMaintenanceRecord'=>array(
						'conditions'=>array(
						'TblMaintenanceRecord.id'=>$_SESSION['TblMaintenanceRecord']['foundset']
					),
					'order'=>array(
						'TblMaintenanceRecord.id ASC'
					),
					'limit'=>10
			));
			$results = $this->paginate('TblMaintenanceRecord');
			$this->set('tbl_maintenance_records', $results);
		} else {
			$this->redirect(array('action'=>'query'));
		}
	}
    function clearfoundset() {
        unset($_SESSION['TblMaintenanceRecord']['foundset']);
        $this->redirect(array('action'=>'index'));
    }




} // end of controller code
?>
