<?php 
class PieChartGalleryController extends AppController { 
	var $name = 'PieChartGallery'; 
	var $uses = 'Member'; 
	var $components = array('Security');
	var $helpers = array('Html', 'Form', 'Paginator', 'Js'); 

	function index() { 
		if (isset($_SESSION['Member']['foundset'])) {
		  $this->redirect(array('action'=>'querylist'));
        }
		$this->layout = "index";
		$this->Member->recursive = -1; 
		$this->set('members', $this->paginate()); 
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'pie_chart_gallery';
		$this->set('page', $page);
	} 

	function view($id = null) { 
		if (!$id || $id == 0) {
			// if invalid id (0) or missing id, use current_record as id
			if (!isset($_SESSION['Member']['current_record']))
				{
				// if invalid id and missing SESSION variable, get first record as current id
				$conditions = array();
				$first_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id ASC')));
				$id = $first_record['Member']['id'];
				$_SESSION['Member']['current_record']=$id;
				}	
				else {
				$id = $_SESSION['Member']['current_record'];				
				}	
		}
		$this->layout = "view";
		// put the current record id into session variable
		$_SESSION['Member']['current_record'] = $id;
		// record navigation variables 
		$this->data=$this->Member->read(null, $id); 
		if (isset($_SESSION['Member']['foundset'])) {
			$conditions = array('Member.id'=>$_SESSION['Member']['foundset']);
			$foundset_record_count = $_SESSION['Member']['foundset'];
			// get record position within foundset
			$record_position = '';
			//RecordPositionComment $record_position = array_search($id,$_SESSION['Member']['foundset']) + 1;
		} else {
			// get list of keys for display of record position
			$record_position = '';
			//RecordPositionComment $conditions = array();
			//RecordPositionComment $record_position_query = $this->Member->find('list', array('fields' => 'Member.id'));
			//RecordPositionComment $record_position_list = array_keys($record_position_query); // resolve all keys to numeric array
			//RecordPositionComment $record_position = array_search($id,$record_position_list) + 1;
			$conditions = array();
			$foundset_record_count = $this->Member->find('count');
		}
					if (isset($_SESSION['toolbar_prev']))
					{
					$page['first'] = $this->Session->read('toolbar_first');
					$page['prev'] = $this->Session->read('toolbar_prev');
					$page['next'] = $this->Session->read('toolbar_next');
					$page['total_record_count'] = $this->Session->read('toolbar_total_record_count');
					$page['foundset_record_count'] = $this->Session->read('toolbar_foundset_record_count');
					$page['last'] = $this->Session->read('toolbar_last');
					$page['record_position'] = $this->Session->read('toolbar_record_position');
					$page['current_model'] = 'Member';
					$page['current_controller'] = 'pie_chart_gallery';
					}
					else 
					{	
		$first_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id ASC')));
		$last_record = $this->Member->find('first', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'),'order'=>array('Member.id DESC')));
		$neighbors = $this->Member->find('neighbors', array('conditions'=>$conditions,'recursive'=>-1, 'fields'=>array('Member.id'), 'field' => 'id', 'value'=> $id));
		$total_record_count = $this->Member->find('count');
		$page = array();
		$page['first'] = $first_record;
		$page['prev'] = $neighbors['prev'];
		$page['next'] = $neighbors['next'];
		$page['total_record_count'] = $total_record_count;
		$page['foundset_record_count'] = $foundset_record_count;
		$page['last'] = $last_record;
		$page['record_position'] = $record_position;
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'pie_chart_gallery';
		if (empty($page['prev'])) {
			$page['prev'] = $first_record;
		}
		if (empty($page['next'])) {
			$page['next'] = $last_record;
		}
					}
					if (isset($_SESSION['toolbar_total_record_count'])) 
					{
					$this->Session->delete('toolbar_first');
					$this->Session->delete('toolbar_prev');
					$this->Session->delete('toolbar_next');
					$this->Session->delete('toolbar_total_record_count');
					$this->Session->delete('toolbar_foundset_record_count');
					$this->Session->delete('toolbar_last');
					$this->Session->delete('toolbar_record_position');
					}
		$this->set('page', $page);
		$_SESSION['MemberCurrentRecord'] = $this->data; // data for Ext JS grid
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());


	} 

	function query() {
		$this->set('indextypedisplayflag','0');
		// Clear SESSION when performing a new search
		unset($_SESSION['Member']['foundset']);
		if (!empty($this->data)) {
			$conditions = array();
			foreach($this->data['Member'] as $key=>$val) {
				if (!empty($val)) {
					// Exact query
					// $conditions['Member.'.$key] = $val;
					// Fuzzy query
					$conditions['Member.'.$key.' LIKE'] = '%'.$val.'%';
				}
			}
			if (!empty($conditions)) {
				$results = $this->Member->find('all', array(
					'conditions'=>$conditions,
					'order'=>array('Member.id ASC'),
				));
				if (!empty($results)) {
					foreach($results as $result) {
						// Save found record IDs into SESSION
						$_SESSION['Member']['foundset'][] = $result['Member']['id'];
					}
				$this->set('indextypedisplayflag','2');
				} else {
					$this->Session->setFlash('0 Records Found.', 'flash_info'); 
				}
			} else {
				$this->Session->setFlash('Please enter at least one query condition.','flash_info'); 
			}
		} 
		$this->layout = "add";

		$page['current_model'] = 'Member';
		$page['current_controller'] = 'pie_chart_gallery';
		$this->set('page', $page);
		$this->set("nav_toolbar_forms_list_value_list",$this->define_nav_toolbar_forms_list_value_list());
	} 

	function querylist() {
		$page['current_model'] = 'Member';
		$page['current_controller'] = 'pie_chart_gallery';
		$this->set('page', $page);
		if (isset($_SESSION['Member']['foundset'])) {
			$this->paginate = array(
					'Member'=>array(
						'conditions'=>array(
						'Member.id'=>$_SESSION['Member']['foundset']
					),
					'order'=>array(
						'Member.id ASC'
					),
					'limit'=>10
			));
			$results = $this->paginate('Member');
			$this->set('members', $results);
		} else {
			$this->redirect(array('action'=>'query'));
		}
	}
    function clearfoundset() {
        unset($_SESSION['Member']['foundset']);
        $this->redirect(array('action'=>'index'));
    }




		function create_chart1($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_saturated.color", TRUE);

			/* Data definition - get data from database - Current Found Set - GroupData/Sort: True, Table/Field Y-Data = Members::Company Count*/
			$YSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company','count(company) AS count'),'group'=>'Member.company'));
			$value_counts = array();
			foreach($YSeriesDataArray as $value) {
				$value_counts[] = $value[0]['count'];
			}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::Company */
			$XSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company'),'group'=>'Member.company'));
			$label_values = array();
			foreach($XSeriesDataArray as $label) {
				$label_values[] = $label['Member']['company'];
			}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,289,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a solid chart background */
			$RectangleSettings = array("R"=>204,"G"=>51,"B"=>0, "Alpha"=>100);
			$myPicture->drawFilledRectangle(0,0,499,289,$RectangleSettings);
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,288,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(21,10,"Chart 1 - Solid 3D - Solid Fill - Found Set",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend or transparent background with a border - border is not drawn */
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,206,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart1.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart1.png');
		}

		function create_chart2($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_primary_basics.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,289,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,288,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(23,10,"Chart 2 - Solid 2D Flat - CurRec - Transparent",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,TRUE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_BOX,"Mode"=>LEGEND_HORIZONTAL , "R"=>255,"G"=>255,"B"=>0, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (Flat) pie chart */
			$PieChart->draw2DPie(249,186,array("Radius"=>76,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>0,"LabelG"=>204,"LabelB"=>255,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart2.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart2.png');
		}

		function create_chart3($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_jewel_tone.color", TRUE);

			/* Data definition - get data from database - Current Found Set - GroupData/Sort: False, Table/Field Y-Data = Members::Company Count*/
			$YSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company','count(company) AS count'),'group'=>'Member.company'));
			$value_counts = array();
			foreach($YSeriesDataArray as $value) {
				$value_counts[] = $value[0]['count'];
			}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::Company */
			$XSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company')));
			$label_values = array();
			foreach($XSeriesDataArray as $label) {
				$label_values[] = $label['Member']['company'];
			}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,289,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,289,DIRECTION_VERTICAL,array("StartR"=>204,"StartG"=>51,"StartB"=>0, "EndR"=>255,"EndG"=>102,"EndB"=>255,"Alpha"=>100));
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,288,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(29,10,"Chart 3 - Shaded 3D - ULBR Fill - Found Set - no group/sort",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			$PieChart->drawPieLegend(50,35,array("Style"=>LEGEND_ROUND,"Mode"=>LEGEND_HORIZONTAL, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Enable drawing of drop shadow */
			$myPicture->setShadow(TRUE,array("X"=>4,"Y"=>6,"R"=>128,"G"=>128,"B"=>128,"Alpha"=>50));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,206,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart3.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart3.png');
		}

		function create_chart4($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_filemaker_colors.color", TRUE);

			/* Data definition - get data from database - Current Found Set - GroupData/Sort: False, Table/Field Y-Data = Members::Company Count*/
			$YSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company','count(company) AS count'),'group'=>'Member.company'));
			$value_counts = array();
			foreach($YSeriesDataArray as $value) {
				$value_counts[] = $value[0]['count'];
			}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::Company */
			$XSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company')));
			$label_values = array();
			foreach($XSeriesDataArray as $label) {
				$label_values[] = $label['Member']['company'];
			}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,289,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,289,DIRECTION_VERTICAL,array("StartR"=>102,"StartG"=>255,"StartB"=>102, "EndR"=>221,"EndG"=>0,"EndB"=>0,"Alpha"=>100));
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,288,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(29,10,"Chart 4 - Shaded 2D - BLUR Fill - Found Set - no group/sort",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(50,35,array("Style"=>LEGEND_ROUND,"Mode"=>LEGEND_HORIZONTAL, "R"=>153,"G"=>102,"B"=>0, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Enable drawing of drop shadow */
			$myPicture->setShadow(TRUE,array("X"=>4,"Y"=>6,"R"=>128,"G"=>128,"B"=>128,"Alpha"=>50));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (Flat) pie chart */
			$PieChart->draw2DPie(249,186,array("Radius"=>76,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart4.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart4.png');
		}

		function create_chart5($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_filemaker_colors.color", TRUE);

			/* Data definition - get data from database - Current Found Set - GroupData/Sort: False, Table/Field Y-Data = Members::Company Count*/
			$YSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company','count(company) AS count'),'group'=>'Member.company'));
			$value_counts = array();
			foreach($YSeriesDataArray as $value) {
				$value_counts[] = $value[0]['count'];
			}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::Company */
			$XSeriesDataArray = $this->Member->find('all', array('fields'=>array('Member.company')));
			$label_values = array();
			foreach($XSeriesDataArray as $label) {
				$label_values[] = $label['Member']['company'];
			}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,289,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,289,DIRECTION_VERTICAL,array("StartR"=>255,"StartG"=>204,"StartB"=>204, "EndR"=>204,"EndG"=>255,"EndB"=>255,"Alpha"=>100));
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,288,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(31,10,"Chart 5 - Shaded 3D - Up/Down Fill - Found Set - no group/sort",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(50,35,array("Style"=>LEGEND_ROUND,"Mode"=>LEGEND_HORIZONTAL, "R"=>153,"G"=>102,"B"=>0, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Enable drawing of drop shadow */
			$myPicture->setShadow(TRUE,array("X"=>4,"Y"=>6,"R"=>128,"G"=>128,"B"=>128,"Alpha"=>50));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,206,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart5.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart5.png');
		}

		function create_chart6($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_pastels.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,283,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,283,DIRECTION_HORIZONTAL,array("StartR"=>136,"StartG"=>136,"StartB"=>136, "EndR"=>255,"EndG"=>255,"EndB"=>255,"Alpha"=>100));
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,282,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(18,10,"Chart 6 - Solid 3D - CurRec - LR Fill",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>204,"G"=>51,"B"=>0));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL, "R"=>255,"G"=>255,"B"=>0));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,202,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>0,"LabelG"=>204,"LabelB"=>255,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart6.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart6.png');
		}

		function create_chart7($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_spring_desert.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,283,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,283,DIRECTION_HORIZONTAL,array("StartR"=>136,"StartG"=>136,"StartB"=>136, "EndR"=>255,"EndG"=>255,"EndB"=>255,"Alpha"=>100));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(22,10,"Chart 7 - Shaded 3D - CurRec - Radial Fill BL",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL, "R"=>255,"G"=>255,"B"=>0));
			/* Enable drawing of drop shadow */
			$myPicture->setShadow(TRUE,array("X"=>4,"Y"=>6,"R"=>128,"G"=>128,"B"=>128,"Alpha"=>50));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,202,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>0,"LabelG"=>204,"LabelB"=>255,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart7.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart7.png');
		}

		function create_chart8($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_gray.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,283,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,283,DIRECTION_HORIZONTAL,array("StartR"=>136,"StartG"=>136,"StartB"=>136, "EndR"=>255,"EndG"=>255,"EndB"=>255,"Alpha"=>100));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(22,10,"Chart 8 - Shaded 3D - CurRec - Radial Fill BR",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_BOX,"Mode"=>LEGEND_HORIZONTAL , "R"=>255,"G"=>255,"B"=>0, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (Flat) pie chart */
			$PieChart->draw2DPie(249,182,array("Radius"=>76,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>255,"LabelG"=>51,"LabelB"=>0,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart8.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart8.png');
		}

		function create_chart9($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_rainbow.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,283,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,283,DIRECTION_HORIZONTAL,array("StartR"=>255,"StartG"=>102,"StartB"=>51, "EndR"=>255,"EndG"=>255,"EndB"=>255,"Alpha"=>100));
			/* Draw Chart Border */
			$myPicture->drawRectangle(0,0,498,282,array("R"=>0,"G"=>0,"B"=>0));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(22,10,"Chart 9 - Shaded 2D - CurRec - Radial Fill UL",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(50,35,array("Style"=>LEGEND_ROUND,"Mode"=>LEGEND_HORIZONTAL, "R"=>255,"G"=>255,"B"=>0, "BorderR"=>51,"BorderG"=>51,"BorderB"=>51));
			/* Enable drawing of drop shadow */
			$myPicture->setShadow(TRUE,array("X"=>4,"Y"=>6,"R"=>128,"G"=>128,"B"=>128,"Alpha"=>50));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (Flat) pie chart */
			$PieChart->draw2DPie(249,182,array("Radius"=>76,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>255,"LabelG"=>51,"LabelB"=>0,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart9.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart9.png');
		}

		function create_chart10($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_plum_tree.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(499,283,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,499,283,DIRECTION_HORIZONTAL,array("StartR"=>255,"StartG"=>51,"StartB"=>0, "EndR"=>0,"EndG"=>204,"EndB"=>255,"Alpha"=>100));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(22,10,"Chart 10 - Solid 3D - CurRec - Radial Fill BR",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Chart Legend */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>8, "R"=>51,"G"=>51,"B"=>51));
			/* pChart doesn't support gradient legend - solid fill is substituted using Color#1 */
			$PieChart->drawPieLegend(20,35,array("Style"=>LEGEND_NOBORDER,"Mode"=>LEGEND_HORIZONTAL, "R"=>255,"G"=>255,"B"=>0));
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(249,202,array("Radius"=>142,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>255,"LabelG"=>255,"LabelB"=>0,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart10.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart10.png');
		}

		function create_chart11($id = null) {
			Configure::write('debug', 0);
			$this->autoRender = false;
			$this->autoLayout = false;
			/* pChart 2.11 library inclusions */
			require_once("../../../pChart/class/pData.class.php");
			require_once("../../../pChart/class/pDraw.class.php");
			require_once("../../../pChart/class/pPie.class.php");
			require_once("../../../pChart/class/pImage.class.php");
			/* pData object creation */
			$MyData = new pData();
			/* Load color palette */
			$MyData->loadPalette("../../../pChart/palettes/FM_muted_rainbow.color", TRUE);

			/* Data definition - get data from database - Current Record (delimited data) -   Y-Axis Data = Members::chart_total_fees_paid_csv, X-Axis Data = Members::chart_company_name_csv*/
			$XYSeriesDataArray = $this->Member->find('first', array('fields'=>array('Member.chart_total_fees_paid_csv','Member.chart_company_name_csv'),'conditions'=>array('Member.id'=>$id)));
			if (strstr($XYSeriesDataArray['Member']['chart_total_fees_paid_csv'],"\r")) {
				// return separated data
				$value_counts = explode("\r", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			else
				{
				$value_counts = explode(",", $XYSeriesDataArray['Member']['chart_total_fees_paid_csv']);
				}
			$MyData->addPoints($value_counts,"Value");

			/* Label definition - get data from database - Table/Field X Data = Members::chart_company_name_csv */
			$label_values = array();
			if (strstr($XYSeriesDataArray['Member']['chart_company_name_csv'],"\r")) {
				// return separated data
				$label_values = explode("\r", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			else
				{
				$label_values = explode(",", $XYSeriesDataArray['Member']['chart_company_name_csv']);
				}
			$MyData->addPoints($label_values,"Legend");
			$MyData->setAbscissa("Legend");
			/* Create the pChart object */
			$myPicture = new pImage(673,499,$MyData);
			$myPicture->Antialias = TRUE;
			/* Draw a linear gradient background */
			$myPicture->drawGradientArea(0,0,673,499,DIRECTION_HORIZONTAL,array("StartR"=>255,"StartG"=>51,"StartB"=>0, "EndR"=>0,"EndG"=>204,"EndB"=>255,"Alpha"=>100));
			/* Chart title */
			/* Set the chart title properties - note: To change font style (bold, italic, underline) - change the TrueType font filename on the next line. */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>13));
			$myPicture->drawText(28,10,"Chart 11 - Solid 3D - CurRec - Radial Fill BR - No Legend",array("R"=>51,"G"=>51,"B"=>51,"Align"=>"TEXT_ALIGN_MIDDLEMIDDLE"));
			/* Create the pPie object */
			$PieChart = new pPie($myPicture,$MyData,FALSE);
			/* Set the pie slice label properties - using FM XAxis properties */
			$myPicture->setFontProperties(array("FontName"=>"../../../pChart/fonts/verdana.ttf","FontSize"=>10, "LabelR"=>51,"LabelG"=>51,"LabelB"=>51));
			/* Draw the (3D) pie chart */
			$PieChart->draw3DPie(336,332,array("Radius"=>224,"DataGapAngle"=>0,"DataGapRadius"=>6,"Border"=>FALSE, "LabelR"=>255,"LabelG"=>255,"LabelB"=>0,"DrawLabels"=>TRUE,"DrawValues"=>TRUE, "ValueR"=>51,"ValueG"=>51,"ValueB"=>51, "WriteValues"=>PIE_VALUE_PERCENTAGE, "ValuePosition"=>PIE_VALUE_INSIDE ));
			/* Render the picture to an image file using Render('../webroot/img/pie_chart_gallery_chart11.png') or send directly to browser using Stroke() */
			$myPicture->Stroke('../webroot/img/pie_chart_gallery_chart11.png');
		}

} // end of controller code
?>
