using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using System.Windows.Markup;
using System.Xml;

namespace Assets002ns
{
    /// <summary>
    /// Interaction logic for assets_v8Window.xaml
    /// </summary>
    public partial class Assets_v8Window : WindowBase
    {

        public Assets_v8Window()
        {
            InitializeComponent();
        }

        private Assets002ns.AssetsDBEntities assetsdbEntities = null;
        System.Windows.Data.CollectionViewSource asset_management2ViewSource = null;
        IQueryable<Assets002ns.asset_management2> asset_management2Query = null;

        IQueryable<Assets002ns.asset_management2>Getasset_management2Query(AssetsDBEntities assetsdbEntities)
          {
              IQueryable<Assets002ns.asset_management2> asset_management2Query = assetsdbEntities.asset_management2;
              return asset_management2Query; // Base Table
          }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            assetsdbEntities = new Assets002ns.AssetsDBEntities();
            // Load data into asset_management2. You can modify this code as needed.
            asset_management2ViewSource = ((System.Windows.Data.CollectionViewSource)(this.FindResource("asset_management2ViewSource")));
            asset_management2Query = this.Getasset_management2Query(assetsdbEntities);
            asset_management2ViewSource.Source = asset_management2Query;
            this.ReBind();
        }
        protected internal override int TotalRecords
        {
            get 
            {
                var currentTable = assetsdbEntities.asset_management2.AsQueryable();
                int maxRecords = currentTable.Count();
                return maxRecords;
            }
        }
        
        protected internal override double CurrentRecordPosition
        {
            get
            {
                return (double)asset_management2ViewSource.View.CurrentPosition;
            }

            set
            {
                int newPosition = (int)value;
                var currentTable = assetsdbEntities.asset_management2.AsQueryable();   
                int maxRecords = currentTable.Count() - 1; 
                
                if(newPosition > maxRecords)
                {
                    newPosition = maxRecords;
                }

                asset_management2ViewSource.View.MoveCurrentToPosition(newPosition);
                NotifyPropertyChanged("CurrentRecordPosition");
            }
        }
        protected internal override void SaveRecords()
        {
            try
            {
                this.assetsdbEntities.SaveChanges();

            }
            catch (Exception)
            {
                //Error handling                
                throw;
            }
        }

        protected internal override void NewRecord()
        {
            try
            {
                var entity = assetsdbEntities.CreateObject<asset_management2>();
                assetsdbEntities.AddToasset_management2(entity);

            }
            catch (Exception)
            {
                //Error Handling
                throw;
            } 
            
            this.SaveRecords(); 
            asset_management2ViewSource.Source = asset_management2Query;
            asset_management2ViewSource.View.MoveCurrentToLast();

            NotifyPropertyChanged("TotalRecords");
        }


        protected internal override void DeleteCurrentRecord()
        {
            try
            {
                var entity = asset_management2ViewSource.View.CurrentItem;
                assetsdbEntities.DeleteObject(entity);

            }
            catch (Exception)
            {
                //Error Handling        
                throw;
            }                    
            this.SaveRecords();
            asset_management2ViewSource.View.Refresh();
            NotifyPropertyChanged("TotalRecords");
        }

        protected internal override void MoveToNextRecord()
        {
            if (asset_management2ViewSource.View.CurrentPosition < ((CollectionView)asset_management2ViewSource.View).Count - 1)
            { 
                asset_management2ViewSource.View.MoveCurrentToNext(); 
            }
                this.SaveRecords();
            NotifyPropertyChanged("CurrentRecordPosition");
        }

        protected internal override void MoveToPreviousRecord()
        {
            if (asset_management2ViewSource.View.CurrentPosition > 0)
            {
                asset_management2ViewSource.View.MoveCurrentToPrevious();
            }
                this.SaveRecords();
            NotifyPropertyChanged("CurrentRecordPosition");
        }

        protected internal override void ReBind() 
        {
            this.Menu_asset_management2__category();
            this.Chkbx_asset_management2__book_value_RebindCheckBoxes();
            this.Radio_asset_management2__radio_btn_test_fld2_RebindRadioButtons();
            this.Chkbx_asset_management2__checkbox_test_fld2_RebindCheckBoxes();
            this.Radio_asset_management2__radio_btn_test_fld1_RebindRadioButtons();
            this.Menu_asset_management2__vl_test_fld1_numeric();
            this.Bind_Menu_asset_management2__vl_test_fld2_numeric();
            this.Chkbx_asset_management2__checkbox_test_fld1_RebindCheckBoxes();
            this.Menu_asset_management2__vl_test_fld1_text();
            this.Chkbx_asset_management2__checkbox_test_fld3_RebindCheckBoxes();
            this.Radio_asset_management2__radio_btn_test_fld3_RebindRadioButtons();
        }
     private void Menu_asset_management2__category()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.category != null)
            {
                string category = data.category.TrimStart(' '); // Drop Down menu
                int i = 0;
                foreach (XmlElement item in menu_asset_management2__category.Items)
                {
                    if (item.InnerText.Equals(category))
                    {
                        menu_asset_management2__category.SelectedIndex = i;
                        return;
                    }
                    i++;
                }
            }
        }

        private void Menu_asset_management2__category_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (asset_management2ViewSource != null)
            {
                 var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
                 if (item.category == null)
                 {
                    item.category = ((XmlElement)menu_asset_management2__category.SelectedItem).InnerText; // Drop Down Menu
                }
            }
        }

        private void Chkbx_asset_management2__book_value_Checked(object sender, RoutedEventArgs e)
        {

            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            item.book_value = 1;            
        }

        private void Chkbx_asset_management2__book_value_UnChecked(object sender, RoutedEventArgs e)
        {

            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            item.book_value = 0;            
        }

        public void Chkbx_asset_management2__book_value_RebindCheckBoxes()
        {
            //Uncheck if they haven't been set 
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.book_value == null)
                 return;
            decimal expectedNumber = 1;
            if (data.book_value.GetType().Equals(typeof(decimal)))
            {
                if (data.book_value.HasValue)
                {
                    chkbx_asset_management2__book_value_0.IsChecked = data.book_value.Equals(expectedNumber);
                }
                else
                {
                    chkbx_asset_management2__book_value_0.IsChecked = false;
                }
            }
        }

        private void Radio_asset_management2__radio_btn_test_fld2_Checked(object sender, RoutedEventArgs e)
        {
            RadioButton rdButton = (RadioButton)sender;
            string data = rdButton.Content as string;
            
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            item.radio_btn_test_fld2 = data;

        }
        public void Radio_asset_management2__radio_btn_test_fld2_RebindRadioButtons()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;

            if (data.radio_btn_test_fld2 != null)
            {
                 switch (data.radio_btn_test_fld2)
                 {
                  case "Office Furniture":
                       radio_asset_management2__radio_btn_test_fld2_0.IsChecked = true;
                      break;
                  case "Computers":
                       radio_asset_management2__radio_btn_test_fld2_1.IsChecked = true;
                      break;
                  case "Telephones":
                       radio_asset_management2__radio_btn_test_fld2_2.IsChecked = true;
                      break;
                  case "-":
                       radio_asset_management2__radio_btn_test_fld2_3.IsChecked = true;
                      break;
                 }
             }
        }


        private void Chkbx_asset_management2__checkbox_test_fld2_Checked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld2 == null)
                return;
             if (!item.checkbox_test_fld2.Contains(data))
            {
                item.checkbox_test_fld2 += "\n" + data;
            }
        }

        private void Chkbx_asset_management2__checkbox_test_fld2_UnChecked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld2 == null)
                return;
            if (item.checkbox_test_fld2.Contains(data))
            {
                item.checkbox_test_fld2.Replace("\n" + data, string.Empty);
            }
        }

        public void Chkbx_asset_management2__checkbox_test_fld2_RebindCheckBoxes()
        {
            //Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld2_0.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld2_1.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld2_2.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld2_3.IsChecked = false;
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.checkbox_test_fld2 == null)
                 return;
            string[] names = data.checkbox_test_fld2.Split('\n');

            for (int i = 0; i < names.Length; i++)
            {
                
                switch (names[i].TrimStart(' '))
                {
                    case "Office Furniture":
                        chkbx_asset_management2__checkbox_test_fld2_0.IsChecked = true;
                        break;
                    case "Computers":
                        chkbx_asset_management2__checkbox_test_fld2_1.IsChecked = true;
                        break;
                    case "Telephones":
                        chkbx_asset_management2__checkbox_test_fld2_2.IsChecked = true;
                        break;
                    case "-":
                        chkbx_asset_management2__checkbox_test_fld2_3.IsChecked = true;
                        break;
                    //default:
                    //    throw new ApplicationException(" error ");
                }
                
            }
        }

        private void Radio_asset_management2__radio_btn_test_fld1_Checked(object sender, RoutedEventArgs e)
        {
            RadioButton rdButton = (RadioButton)sender;
            string data = rdButton.Content as string;
            
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            item.radio_btn_test_fld1 = data;

        }
        public void Radio_asset_management2__radio_btn_test_fld1_RebindRadioButtons()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;

            if (data.radio_btn_test_fld1 != null)
            {
                 switch (data.radio_btn_test_fld1)
                 {
                  case "Office Furniture":
                       radio_asset_management2__radio_btn_test_fld1_0.IsChecked = true;
                      break;
                  case "Computers":
                       radio_asset_management2__radio_btn_test_fld1_1.IsChecked = true;
                      break;
                  case "Telephones":
                       radio_asset_management2__radio_btn_test_fld1_2.IsChecked = true;
                      break;
                  case "Table":
                       radio_asset_management2__radio_btn_test_fld1_3.IsChecked = true;
                      break;
                  case "Chair":
                       radio_asset_management2__radio_btn_test_fld1_4.IsChecked = true;
                      break;
                  case "Router":
                       radio_asset_management2__radio_btn_test_fld1_5.IsChecked = true;
                      break;
                 }
             }
        }

     private void Menu_asset_management2__vl_test_fld1_numeric()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.vl_test_fld1_numeric != null)
            {
                string vl_test_fld1_numeric = data.vl_test_fld1_numeric.ToString();
                int i = 0;
                foreach (XmlElement item in menu_asset_management2__vl_test_fld1_numeric.Items)
                {
                    if (item.InnerText.Equals(vl_test_fld1_numeric))
                    {
                        menu_asset_management2__vl_test_fld1_numeric.SelectedIndex = i;
                        return;
                    }
                    i++;
                }
            }
        }

        private void Menu_asset_management2__vl_test_fld1_numeric_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (asset_management2ViewSource != null)
            {
                 var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
                 if (item.vl_test_fld1_numeric == null)
                 {
                    item.vl_test_fld1_numeric = decimal.Parse(((XmlElement)menu_asset_management2__vl_test_fld1_numeric.SelectedItem).InnerText);
                }
            }
        }
     private void Bind_Menu_asset_management2__vl_test_fld2_numeric()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.vl_test_fld2_numeric != null)
            {
                string vl_test_fld2_numeric = data.vl_test_fld2_numeric.ToString();
                int i = 0;
                foreach (XmlElement item in menu_asset_management2__vl_test_fld2_numeric.Items)
                {
                    if (item.InnerText.Equals(vl_test_fld2_numeric))
                    {
                        menu_asset_management2__vl_test_fld2_numeric.SelectedIndex = i;
                        return;
                    }
                    i++;
                }
            }
        }

        private void Menu_asset_management2__vl_test_fld2_numeric_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (asset_management2ViewSource != null)
            {
                var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
                if (item.vl_test_fld2_numeric != null)
                {
                    item.vl_test_fld2_numeric = decimal.Parse(((XmlElement)menu_asset_management2__vl_test_fld2_numeric.SelectedItem).InnerText);
                }
            }
        }

        private void Chkbx_asset_management2__checkbox_test_fld1_Checked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld1 == null)
                return;
             if (!item.checkbox_test_fld1.Contains(data))
            {
                item.checkbox_test_fld1 += "\n" + data;
            }
        }

        private void Chkbx_asset_management2__checkbox_test_fld1_UnChecked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld1 == null)
                return;
            if (item.checkbox_test_fld1.Contains(data))
            {
                item.checkbox_test_fld1.Replace("\n" + data, string.Empty);
            }
        }

        public void Chkbx_asset_management2__checkbox_test_fld1_RebindCheckBoxes()
        {
            //Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld1_0.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld1_1.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld1_2.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld1_3.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld1_4.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld1_5.IsChecked = false;
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.checkbox_test_fld1 == null)
                 return;
            string[] names = data.checkbox_test_fld1.Split('\n');

            for (int i = 0; i < names.Length; i++)
            {
                
                switch (names[i].TrimStart(' '))
                {
                    case "Office Furniture":
                        chkbx_asset_management2__checkbox_test_fld1_0.IsChecked = true;
                        break;
                    case "Computers":
                        chkbx_asset_management2__checkbox_test_fld1_1.IsChecked = true;
                        break;
                    case "Telephones":
                        chkbx_asset_management2__checkbox_test_fld1_2.IsChecked = true;
                        break;
                    case "Table":
                        chkbx_asset_management2__checkbox_test_fld1_3.IsChecked = true;
                        break;
                    case "Chair":
                        chkbx_asset_management2__checkbox_test_fld1_4.IsChecked = true;
                        break;
                    case "Router":
                        chkbx_asset_management2__checkbox_test_fld1_5.IsChecked = true;
                        break;
                    //default:
                    //    throw new ApplicationException(" error ");
                }
                
            }
        }

     private void Menu_asset_management2__vl_test_fld1_text()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.vl_test_fld1_text != null)
            {
                string vl_test_fld1_text = data.vl_test_fld1_text.TrimStart(' '); // Drop Down menu
                int i = 0;
                foreach (XmlElement item in menu_asset_management2__vl_test_fld1_text.Items)
                {
                    if (item.InnerText.Equals(vl_test_fld1_text))
                    {
                        menu_asset_management2__vl_test_fld1_text.SelectedIndex = i;
                        return;
                    }
                    i++;
                }
            }
        }

        private void Menu_asset_management2__vl_test_fld1_text_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (asset_management2ViewSource != null)
            {
                 var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
                 if (item.vl_test_fld1_text == null)
                 {
                    item.vl_test_fld1_text = ((XmlElement)menu_asset_management2__vl_test_fld1_text.SelectedItem).InnerText; // Drop Down Menu
                }
            }
        }

        private void Chkbx_asset_management2__checkbox_test_fld3_Checked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld3 == null)
                return;
             if (!item.checkbox_test_fld3.Contains(data))
            {
                item.checkbox_test_fld3 += "\n" + data;
            }
        }

        private void Chkbx_asset_management2__checkbox_test_fld3_UnChecked(object sender, RoutedEventArgs e)
        {
            CheckBox chkBox = (CheckBox)sender;

            string data = chkBox.Content as string;
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (item.checkbox_test_fld3 == null)
                return;
            if (item.checkbox_test_fld3.Contains(data))
            {
                item.checkbox_test_fld3.Replace("\n" + data, string.Empty);
            }
        }

        public void Chkbx_asset_management2__checkbox_test_fld3_RebindCheckBoxes()
        {
            //Uncheck if they haven't been set 
            chkbx_asset_management2__checkbox_test_fld3_0.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld3_1.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld3_2.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld3_3.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld3_4.IsChecked = false;
            chkbx_asset_management2__checkbox_test_fld3_5.IsChecked = false;
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            if (data.checkbox_test_fld3 == null)
                 return;
            string[] names = data.checkbox_test_fld3.Split('\n');

            for (int i = 0; i < names.Length; i++)
            {
                
                switch (names[i].TrimStart(' '))
                {
                    case "Office Furniture":
                        chkbx_asset_management2__checkbox_test_fld3_0.IsChecked = true;
                        break;
                    case "Computers":
                        chkbx_asset_management2__checkbox_test_fld3_1.IsChecked = true;
                        break;
                    case "Telephones":
                        chkbx_asset_management2__checkbox_test_fld3_2.IsChecked = true;
                        break;
                    case "Table":
                        chkbx_asset_management2__checkbox_test_fld3_3.IsChecked = true;
                        break;
                    case "Chair":
                        chkbx_asset_management2__checkbox_test_fld3_4.IsChecked = true;
                        break;
                    case "Router":
                        chkbx_asset_management2__checkbox_test_fld3_5.IsChecked = true;
                        break;
                    //default:
                    //    throw new ApplicationException(" error ");
                }
                
            }
        }

        private void Radio_asset_management2__radio_btn_test_fld3_Checked(object sender, RoutedEventArgs e)
        {
            RadioButton rdButton = (RadioButton)sender;
            string data = rdButton.Content as string;
            
            var item = (asset_management2)asset_management2ViewSource.View.CurrentItem;
            item.radio_btn_test_fld3 = data;

        }
        public void Radio_asset_management2__radio_btn_test_fld3_RebindRadioButtons()
        {
            var data = (asset_management2)asset_management2ViewSource.View.CurrentItem;

            if (data.radio_btn_test_fld3 != null)
            {
                 switch (data.radio_btn_test_fld3)
                 {
                  case "Office Furniture":
                       radio_asset_management2__radio_btn_test_fld3_0.IsChecked = true;
                      break;
                  case "Computers":
                       radio_asset_management2__radio_btn_test_fld3_1.IsChecked = true;
                      break;
                  case "Telephones":
                       radio_asset_management2__radio_btn_test_fld3_2.IsChecked = true;
                      break;
                  case "Table":
                       radio_asset_management2__radio_btn_test_fld3_3.IsChecked = true;
                      break;
                  case "Chair":
                       radio_asset_management2__radio_btn_test_fld3_4.IsChecked = true;
                      break;
                  case "Router":
                       radio_asset_management2__radio_btn_test_fld3_5.IsChecked = true;
                      break;
                 }
             }
        }


    }
}
